/*
 * File:		main.c
 * Purpose:		Main process
 *
 */

#include "src/init/m5282evb.h"
#include "environment.h"
#include "moveRam.h"
#include "march.h"



UINT32 *asmAddr; //Global variable for inline asm
					
/********************************************************************/

void main (void) {
   	UINT32 *addr;
   	UINT32 data;
   	int i;
   	int result;
   	int r[10];	

   	/*Configure PORT D as GPIO*/	
	MCF5282_GPIO_PBCDPAR = (0x0);
	COMMENT("Configure PORTD as GPIO outputs\n");
   	WR8(MCF5282_GPIO_DDRD, 0xFF);
   	COMMENT("Initialize PORTD to 0 - used as FAIL\n");
   	WR8(MCF5282_GPIO_PORTD, 0x00);
   	
   	ASM(move.w #0x2000,sr); /* Set supervisor mode */
	 
   	/*Protect IPSBAR space from caching*/
   	ASM(move.l #0x4000C040,d0);
   	ASM(movec d0,acr1);
   
   	/*Disable and invalidate the entire cache*/
   	ASM(move.l #0x01800103,d0);  /* disable-and-invalidate cache CACR value*/
   	ASM(movec d0,cacr);
   	/*Enable the cache (as data only)*/
   	ASM(move.l #0x80800103,d0);  /* enable-and-unlock-cache CACR value*/
   	ASM(movec d0,cacr);
 
   	r[0] =   tagMarchPat (0xaaaaaa80);
   	r[1] =   tagMarchPat (0x55555500);
   	r[2] =   tagMarchPat (0x33333300);
   	r[3] =   tagMarchPat (0xCCCCCC80);
   	r[4] =   tagMarchPat (0x0f0f0f00);
   	r[5] =   tagMarchPat (0xf0f0f080);
   	r[6] =   tagMarchPat (0x00ff0080);
   	r[7] =   tagMarchPat (0xffff0000);

   	result = r[0]|r[1]|r[2]|r[3]|r[4]|r[5]|r[6]|r[7];

   	COMMENT("March returned, write result to PORTD\n");
   	WR8 (MCF5282_GPIO_PORTD, result);
   	for (i=0; i<100; i++); /*Keep the result around for a while*/
     switch (result) {
      case MARCHPASS:  COMMENT ("MARCHPASS.\n");
      break;
      case FAILFILL:   COMMENT ("FAILFILL.\n");
      break;
  	}
  
  	while(1);

}

/********************************************************************/
__interrupt__
void irq7_handler (void) 
{

	
}


/********************************************************************/
__interrupt__
void swt_handler (void) 
{

	
}